;   FILENAME: PPSCMD.ASM
;
;   Last updated : July 27, 1992

jumps      ; Have TASM automatically resolve out of range jumps

%tabsize 4

ifndef  MDL
    display "Error: This module requires that you provide a memory model"
    display "    definition on the command line. I.E. /dMDL=SMALL."
    err ; Force a fatal error
else

model	MDL,pascal	       ; Define the memory model
P286

Version EQU "1.00"

ideal

stack	1024	       ; Allocate 4K stack

codeseg

SizeOfProg	dw	0

include "globals.inc"
include "pps.inc"

codeseg

;Ŀ
;
;Ŀ
;

codeseg
SavedDS     dw	?	; For the control-break handler to find the path
			; variables for restoring the original path and
			; drive.


dataseg

PspAddress      dw      ?       ; Segment address of Program Segment Prefix(PSP)

codeseg

proc Main

;************************* Program Entry Point ***************************
; Execution of the program begins here.

EntryPoint:
	mov	ax, @data	; Initialize ds by moving segment address
	mov	ds, ax		; of data segment into ds register

	call	DoAll
endp    main

proc	DoAll

	; Store the PSP address by storing es in the variable PspAddress.
	; Note that we do it this way instead of using DOS function 62h because
	; the function is only available on DOS 3.0 or later.

	mov	[PspAddress], es
	push	es
	mov	ax, seg PSPAddress
	mov	es, ax
	mov	bx, [es:PSPAddress]
	mov	es, bx
	mov	ax, zzzzzseg
	sub	ax, bx
	mov	bx,ax
	inc	bx			;Safety margin
	inc	bx
	mov	[cs:SizeOfProg],bx
	mov	ah, 4ah 		;Memory block resize opcode
	int	21h
	pop	es

	mov	ax,ds
	mov	[SavedDS],ax

@@1:
ifdef OSC
	mov	ax,13h
	int	10h
endif OSC
	mov	bx,255
	call	sd_InitSound

        mov     ds, [PspAddress]    ; Load the segment address of the Psp
	mov	si, offset (Psp).CommandTail
	lodsb
	cmp	al,0
	jz	@@Terminate

@@MoreThanOne:
	mov	bx,si
	xor	ah,ah
	add	bx,ax
@@TopLoop:
	cmp	bx,si
	jz	@@Terminate
	lodsb
        cmp     al,32
        jz      @@TopLoop
@@GetFilename:
	xor	ah,ah
	dec	si
	mov	cx,80
@@TopGet:
	cmp	bx,si
	jz	@@StoreFilename
	lodsb
	cmp	al,'.'
	jnz	@@NotPeriod
	mov	ah,1
@@NotPeriod:
	cmp	al,13
	jz	@@StoreFilename
	loop	@@TopGet
@@StoreFilename:
	or	ah,ah
	jnz	@@JustZero
	mov	[Byte si],'.'
	mov	[Byte si+1],'M'
	mov	[Byte si+2],'O'
	mov	[Byte si+3],'D'
	add	si,4
@@JustZero:
	mov	[Byte si],0
	mov	dx, offset (Psp).CommandTail + 2
        call    sd_LoadModule
        jnb     @@ModuleLoadedOK
ifdef OSC
	mov	ax,3
	int	10h
endif OSC
        mov     ax,4C00h
        int     21h
@@ModuleLoadedOK:
	mov	ax,@data
	mov	ds,ax
	call	sd_PlayMusic
@@MStat:
	mov	ah,1
	int	16h
	jnz	@@Done
	cmp	[MStatus],0
	jz	@@MStat
@@Done:
	call	sd_CloseAllMusic
@@Terminate:
;	 mov	 dx,[cs:SizeOfProg]
;	 mov	 ah,31h
;	 int	 21h
ifdef OSC
	mov	ax,3
	int	10h
endif OSC
        mov     ax, 4C00h
        int     21h
	ret
endp	DoAll

segment zzzzzseg   ; Dummy final segment for calculating program size
                   ; to release memory back to DOS.
LastBytes	db	16 dup (?)
ends    zzzzzseg

endif   ; ifndef MDL

end EntryPoint

